/**************************************************************************/
/* FILE NAME:                              COPYRIGHT (c) Freescale 2008   */
/* ISR_Routines_Dual.c                            All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This is the interrupt controller configuration file.                   */
/*=========================================================================*/
/*                                                                        */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.1    R. Moran       10/12/2008    Initial Version                    */
/**************************************************************************/
#include "mpc5668.h"

/*========================================================================*/
/*                      GLOBAL VARIABLES                                  */
/*========================================================================*/
uint32_t a1, count1; 
/*========================================================================*/
/*                     INTERRUPT PRIORITIES                               */
/*========================================================================*/
/**************************************************************************/
/* FUNCTION     : Init_INTC_Priority                                      */
/* PURPOSE      : SET Interrupt Vector PRIORITIES HERE                    */
/**************************************************************************/
void Init_INTC_Priority(void) {
	
	/* PSR: Interrupt Priority Select Register */
	 
	 /* Select Priority - 0 = lowest, 15 = highest */
	 INTC.PSR[149].B.PRI = 1;
     /* Select Processor to handle IRQ */
	 INTC.PSR[149].B.PRC_SEL = 0;     /* 0x0 - PRC0=Z6, 0x1 - both, 0x3 - PRC1=Z0 */
     
}

/*========================================================================*/
/*                   INTERRUPT SERVICE ROUTINES                           */
/*========================================================================*/

/**************************************************************************/
/* FUNCTION     : PIT1_ISR                                                */
/* PURPOSE      : ISR which is entered if PIT channel 1 vector is         */
/*                called.                                                 */
/**************************************************************************/

void PIT1_ISR (void) {

	for (a1=0; a1<5; a1++)							/* loop five times */
	{
		for (count1=0; count1<200000; count1++);	/* loops to toggle PE1 */
		SIU.GPDO[65].R = 0x01;
		for (count1=0; count1<200000; count1++);
		SIU.GPDO[65].R = 0x00;
		PIT.TFLG1.B.TIF = 1;					/* clear interrupt flag */
	}	

}

/**************************************************************************/
/* FUNCTION     : dummy                                                   */
/* PURPOSE      : Dummy ISR which is entered if any non-used vector       */
/*                is called.                                              */
/**************************************************************************/

void Dummy_ISR (void) {

    /* Wait forever */
    while (1);
}